﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Projekt_DziedziczenieTabelaNaHierarchie
{
    class Program
    {
        static void Main(string[] args)
        {
            PobierzTylkoProduktySpozywcze();
            Console.ReadKey();
        }

        static void PobierzTylkoProduktySpozywcze()
        {
            using (var context = new TestowaBazaDanychEntities())
            {
                var query = context.Produkt.OfType<ProduktSpozywczy>();

                foreach (ProduktSpozywczy ps in query)
                {
                    Console.WriteLine("Nazwa={0}, Waga={1}", ps.Nazwa, ps.Waga);
                }
            }
        }


        static void SprawdzTyp()
        {
            using (var context = new TestowaBazaDanychEntities())
            {
                var query = context.Produkt;

                foreach (Produkt p in query)
                {
                    if (p is ProduktSpozywczy)
                    {
                        ProduktSpozywczy ps = p as ProduktSpozywczy;
                        Console.WriteLine("Nazwa={0}, Waga={1}", ps.Nazwa, ps.Waga);
                    }
                    else if (p is ProduktOdziezowy)
                    {
                        ProduktOdziezowy po = p as ProduktOdziezowy;
                        Console.WriteLine("Nazwa={0}, Rozmiar={1}", po.Nazwa, po.Rozmiar);
                    }
                    else
                    {
                        Console.WriteLine("Nazwa={0}", p.Nazwa);
                    }
                }

            }
        }

    }
}
